``` python
# Połączenie definiujemy za pomocą ciągu znaków z adresem URI wykorzystującym
# format DNS Seedlist
uriString = 'mongodb+srv://server.example.com/'
client = MongoClient(uriString)

my_wc_majority = WriteConcern('majority', wtimeout=1000)

# Wstęp / Krok 0: Tworzenie kolekcji (o ile jeszcze nie istnieją).
# Operacje CRUD w transakcjach muszą być wykonywane na istniejących kolekcjach.

client.get_database( "webshop",
                     write_concern=my_wc_majority).orders.insert_one({"sku":
                     "abc123", "qty":0})
client.get_database( "webshop",
                     write_concern=my_wc_majority).inventory.insert_one(
                     {"sku": "abc123", "qty": 1000})

# Krok 1: Definiowanie funkcji wywołania zwrotnego definiującej operacje do wykonania
# oraz ich kolejność.
def callback(my_session):
    orders = my_session.client.webshop.orders
    inventory = my_session.client.webshop.inventory

    # Ważne:: Do obu operacji trzeba przekazać zmienną 'my_session'
    # przechowującą dane sesji.

    orders.insert_one({"sku": "abc123", "qty": 100}, session=my_session)
    inventory.update_one({"sku": "abc123", "qty": {"$gte": 100}},
                         {"$inc": {"qty": -100}}, session=my_session)

# Krok 2: Uruchomienie sesji klienta.

with client.start_session() as session:

# Krok 3: Funkcja with_transaction uruchamia transakcję, wykonuje funkcję wywołania zwrotnego
# i zatwierdza całość (albo przerywa pracę z błędem).

    session.with_transaction(callback,
                             read_concern=ReadConcern('local'),
                             write_concern=my_write_concern_majority,
                             read_preference=ReadPreference.PRIMARY)
```