``` javascript
# Połączenie definiujemy za pomocą ciągu znaków z adresem URI wykorzystującym
# format DNS Seedlist
uri = 'mongodb+srv://server.example.com/'
client = MongoClient(uriString)

my_wc_majority = WriteConcern('majority', wtimeout=1000)

# Wstęp / Krok 0: Tworzenie kolekcji (o ile jeszcze nie istnieją).
# Operacje CRUD w transakcjach muszą być wykonywane na istniejących kolekcjach.

client.get_database( "webshop",
                     write_concern=my_wc_majority).orders.insert_one({"sku":
                     "abc123", "qty":0})
client.get_database( "webshop",
                     write_concern=my_wc_majority).inventory.insert_one(
                     {"sku": "abc123", "qty": 1000})

# Krok 1: Definiowanie operacji i sekwencji ich wykonania w transakcji.
def update_orders_and_inventory(my_session):
    orders = session.client.webshop.orders
    inventory = session.client.webshop.inventory
    with session.start_transaction(
            read_concern=ReadConcern("snapshot"),
            write_concern=WriteConcern(w="majority"),
            read_preference=ReadPreference.PRIMARY):

        orders.insert_one({"sku": "abc123", "qty": 100}, session=my_session)
        inventory.update_one({"sku": "abc123", "qty": {"$gte": 100}},
                             {"$inc": {"qty": -100}}, session=my_session)
        commit_with_retry(my_session)

# Krok 2: Próba uruchomienia i zatwierdzenia transakcji w połączeniu z logiką powtórzeń.
def commit_with_retry(session):
    while True:
        try:
            # Zatwierdzenie transakcji używa parametrów ustalonych przy jej uruchamianiu.
            session.commit_transaction()
            print("Transakcja została zatwierdzona.")
            break
        except (ConnectionFailure, OperationFailure) as exc:
            # Można ponownie spróbować zatwierdzić transakcję.
            if exc.has_error_label("UnknownTransactionCommitResult"):
                print("UnknownTransactionCommitResult, próba ponownego "
                      "zatwierdzenia transakcji...")
                continue
            else:
                print("Podczas zatwierdzania wystąpił błąd ...")
                raise

# Krok 3: Próba uruchomienia funkcji transakcji txn_func w połączeniu z logiką powtórzeń.
def run_transaction_with_retry(txn_func, session):
    while True:
        try:
            txn_func(session) # przeprowadza transakcję
            break
        except (ConnectionFailure, OperationFailure) as exc:
            # Jeżeli to błąd przejściowy, to spróbuj ponownie wykonać transakcję.
            if exc.has_error_label("TransientTransactionError"):
                print("TransientTransactionError, próbuję ponownie ...")
                continue
            else:
                raise

# Krok 4: Uruchomienie transkacji.
with client.start_session() as my_session:

# Krok 5: Wywołanie funkcji 'run_transaction_with_retry' i przekazanie jej funkcji
# 'update_orders_and_inventory' oraz sesji 'my_session' związanych z tą transakcją.

    try:
        run_transaction_with_retry(update_orders_and_inventory, my_session)
    except Exception as exc:
        # W jakiś sposób obsłuż ten błąd. W podstawowym API nie ma domyślnej obsługi
        # tego rodzaju błędów.
        raise
```