// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Web.UI;
using Microsoft.Web.Testing;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// Test Driver
    /// </summary>
    public partial class TestStatus : Page
    {
        /// <summary>
        /// Set values of the page's controls
        /// </summary>
        /// <param name="e">EventArgs</param>
        protected override void  OnLoad(EventArgs e)
        {
 	         base.OnLoad(e);

            // Only auto-select or auto-run on the first request
            if (!IsPostBack)
            {
                // Get query string values
                string tag;
                bool run, hasTag, filter, skipfail, syncLogs;
                WebTestLogDetail logDetail;

                TestDriver.ProcessQueryString(Request.QueryString, out run, out hasTag, out tag, out filter, out skipfail, out logDetail, out syncLogs);

                chkFilter.Checked = filter;
                chkSkipFail.Checked = skipfail;
                cmbVerbosity.SelectedIndex = (int) logDetail;
                chkSync.Checked = syncLogs;

                if (run)
                {
                    btnRun.Enabled = false;
                    chkFilter.Enabled = false;
                    chkSkipFail.Enabled = false;
                    cmbVerbosity.Enabled = false;
                }
            }
        }
    }
}