<%@ Page
    Language="C#"
    CodeFile="ObjectDataSource.aspx.cs"
    Inherits="AjaxControlToolkit.Testing.Client.ReorderList.ObjectDataSource" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>ReorderList - ObjectDataSource</title>
    <style type="text/css">
        .dragHandle
        {
            width: 10px;
            height: 10px;
            border: thin outset white;
            background-color: red;
        }
        
        .processing
        {
            background-color: yellow;
            color: black;
            border: thin inset white;
        }
        
        .reorderCue
        {
            background-color: green;
            border: thin dotted black;
            height: 25px;
        }
        
        li
        {
            list-style: none;
        }
    </style>
</head>
<body><form id="form" runat="server"><div>
    <b>ReorderList - ObjectDataSource</b><br />
    ReorderList bound to an ObjectDataSource<br /><br /><br />
    
    <ajaxToolkit:ToolkitScriptManager ID="ScriptManager" runat="server" />
    
    <ajaxToolkit:ReorderList ID="List" runat="server" DataSourceID="DataSource" CallbackCssStyle="processing"
        DragHandleAlignment="Left" ItemInsertLocation="Beginning" DataKeyField="ItemID" SortOrderField="Priority">
        <ItemTemplate>
            <%# HttpUtility.HtmlEncode(Convert.ToString(Eval("ItemID"))) %>
        </ItemTemplate>
        <ReorderTemplate>
            <asp:Panel ID="Panel2" runat="server" CssClass="reorderCue" />
        </ReorderTemplate>
        <DragHandleTemplate>
            <div class="dragHandle" />
        </DragHandleTemplate>
        <InsertItemTemplate>
            <!-- bottom border is workaround for IE7 Beta issue where bg doesn't render -->
            <div style="padding-left: 25px; border-bottom: thin solid transparent;">
                <asp:Panel ID="AddItem" runat="server" DefaultButton="btnAdd">
                    <asp:TextBox ID="txtTitle" runat="server" Text='<%# Bind("Title") %>' />
                    <asp:Button ID="btnAdd" runat="server" CommandName="Insert" Text="Add" />
                    <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server"
                        ErrorMessage="Please enter some text" ControlToValidate="txtTitle" />
                </asp:Panel>
            </div>
        </InsertItemTemplate>
    </ajaxToolkit:ReorderList>
    
    <asp:ObjectDataSource ID="DataSource" runat="server" DeleteMethod="Delete"
        InsertMethod="Insert" OldValuesParameterFormatString="original_{0}" SelectMethod="Select"
        TypeName="SessionTodoXmlDataObject" UpdateMethod="Update">
        <DeleteParameters>
            <asp:Parameter Name="Original_ItemID" Type="Int32" />
        </DeleteParameters>
        <UpdateParameters>
            <asp:Parameter Name="Title" Type="String" />
            <asp:Parameter Name="Description" Type="String" />
            <asp:Parameter Name="Priority" Type="Int32" />
            <asp:Parameter Name="Original_ItemID" Type="Int32" />
        </UpdateParameters>
        <InsertParameters>
            <asp:Parameter Name="Title" Type="String" />
            <asp:Parameter Name="Description" Type="String" />
            <asp:Parameter Name="Priority" Type="Int32" />
        </InsertParameters>
    </asp:ObjectDataSource>
    
</div></form></body>
</html>