// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Web.UI.WebControls;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// AjaxControlToolkit.ValidatorCalloutExtender Model
    /// </summary>
    /// <TestComponent Name="ValidatorCallout">
    ///   <ToolkitType>AjaxControlToolkit.ValidatorCalloutExtender</ToolkitType>
    ///   <CommonTestSuite>AjaxControlToolkit.Testing.Client.ValidatorCallout.ValidatorCallout_Common</CommonTestSuite>
    /// </TestComponent>
    public class ValidatorCalloutBehavior : Behavior<HtmlElement>
    {
        /// <summary>
        /// WarningIconImageUrl
        /// </summary>
        public BehaviorProperty<string> WarningIconImageUrl
        {
            get { return _warningIconImageUrl; }
        }
        private BehaviorProperty<string> _warningIconImageUrl;

        /// <summary>
        /// CloseImageUrl
        /// </summary>
        public BehaviorProperty<string> CloseImageUrl
        {
            get { return _closeImageUrl; }
        }
        private BehaviorProperty<string> _closeImageUrl;

        /// <summary>
        /// HighlightCssClass
        /// </summary>
        public BehaviorProperty<string> HighlightCssClass
        {
            get { return _highlightCssClass; }
        }
        private BehaviorProperty<string> _highlightCssClass;

        /// <summary>
        /// Width
        /// </summary>
        public BehaviorProperty<Unit> Width
        {
            get { return _width; }
        }
        private BehaviorProperty<Unit> _width;

        /// <summary>
        /// PopupTable
        /// </summary>
        public ReferenceBehaviorProperty<HtmlElement> PopupElement
        {
            get { return _popupElement; }
        }
        private ReferenceBehaviorProperty<HtmlElement> _popupElement;

        /// <summary>
        /// PopupBehavior
        /// </summary>
        public PopupBehavior PopupBehavior
        {
            get
            {
                if (_popupBehavior == null)
                {
                    _popupBehavior = new PopupBehavior(
                        _popupElement.Reference,
                        BehaviorID + "_PopupBehavior",
                        string.Format("{0}._popupBehavior", this.BehaviorReferenceExpression),
                        Page);
                }
                return _popupBehavior;
            }
        }
        private PopupBehavior _popupBehavior;

        /// <summary>
        /// IsOpen
        /// </summary>
        public BehaviorProperty<bool> IsOpen
        {
            get { return _isOpen; }
        }
        private BehaviorProperty<bool> _isOpen;

        /// <summary>
        /// AjaxControlToolkit.ValidatorCalloutExtender Model
        /// </summary>
        /// <param name="element">Target element</param>
        /// <param name="behaviorID">Behavior ID</param>
        /// <param name="page">Page Model</param>
        public ValidatorCalloutBehavior(HtmlElement element, string behaviorID, ToolkitTestPage page)
            : base(element, behaviorID, page)
        {
            _warningIconImageUrl = BehaviorProperty<string>.CreateProperty(this, "warningIconImageUrl");
            _closeImageUrl = BehaviorProperty<string>.CreateProperty(this, "closeImageUrl");
            _highlightCssClass = BehaviorProperty<string>.CreateProperty(this, "highlightCssClass");
            _width = BehaviorProperty<Unit>.CreateProperty(this, "width", ConvertToUnit);

            _popupElement = ReferenceBehaviorProperty<HtmlElement>.CreateField(this, "id", ReadStrategy.Demand, WriteStrategy.Immediate, "{0}._popupTable");
            _isOpen = BehaviorProperty<bool>.CreateProperty(this, "isOpen");
        }

        private static Unit ConvertToUnit(object obj)
        {
            return ((null == obj) ? Unit.Empty : Unit.Parse(obj.ToString()));
        }
    }
}
