// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.ValidatorCallout;

/// <summary>
/// ValidatorCallout for a ServerValidator
/// </summary>
/// <TestSuite>
///   <Path>ValidatorCallout\ServerValidator.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.ValidatorCalloutBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.ValidatorCallout.ServerValidatorPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("ValidatorCallout.ServerValidator")]
public class ValidatorCallout_ServerValidator : AjaxControlToolkit.Testing.Client.ValidatorCallout.ValidatorCallout_Common
{
    public override IEnumerable<ValidatorCalloutScenario> ValidatorCalloutScenarios
    {
        get
        {
            ServerValidatorPage page = new ServerValidatorPage();
            yield return new ValidatorCalloutScenario(page.ValidatorCalloutServer, page.TextBoxRequired, "a", "1", page.Button, true, true);
        }
    }
}
