// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.Tabs;

/// <summary>
/// Basic tabs tests
/// </summary>
/// <TestSuite>
///   <Path>Tabs\Simple.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.TabContainerBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.Tabs.SimplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("Tabs.Simple")]
public class Tabs_Simple : AjaxControlToolkit.Testing.Client.Tabs.Tabs_Common
{
    public const string DynamicContent = "Dynamic context content!";

    [WebTestMethod]
    public void ChangeTab()
    {
        SimplePage page = new SimplePage();
        ChangeTabPanel(page.Tabs1, 0, 2);
    }

    [WebTestMethod]
    public void ShowHiddenTab()
    {
        SimplePage page = new SimplePage();
        TabPanelBehavior panel = page.Tabs1.TabPanels.Value[1];
        Assert.AreEqual(Display.None, panel.Tab.Reference.GetAttributes().Style.Display);
        panel.Enabled.Value = true;
        Assert.AreNotEqual(Display.None, panel.Tab.Reference.GetAttributes().Style.Display);
    }

    [WebTestMethod]
    public void ActivateHiddenTab()
    {
        SimplePage page = new SimplePage();
        TabPanelBehavior panel = page.Tabs1.TabPanels.Value[1];
        Assert.AreEqual(Display.None, panel.Tab.Reference.GetAttributes().Style.Display);
        page.Tabs1.ActiveTab = panel;
        Assert.AreNotEqual(Display.None, panel.Tab.Reference.GetAttributes().Style.Display);
        Assert.IsTrue(panel.Active.Value);
    }

    [WebTestMethod]
    public void Postback()
    {
        SimplePage page = new SimplePage();
        TabPanelBehavior panel1 = page.Tabs1.TabPanels.Value[1];
        TabPanelBehavior panel2 = page.Tabs1.TabPanels.Value[2];
        
        panel1.Enabled.Value = true;
        panel2.Enabled.Value = false;
        page.Tabs1.ActiveTabIndex.Value = 1;
        
        page.Postback.Click(true);
        page.InvalidateAndRequire(panel1.Enabled, panel2.Enabled, page.Tabs1.ActiveTabIndex);

        Assert.AreEqual(1, page.Tabs1.ActiveTabIndex.Value);
        Assert.IsTrue(panel1.Enabled.Value);
        Assert.IsFalse(panel2.Enabled.Value);
    }

    [WebTestMethod]
    public void DynamicContext()
    {
        SimplePage page = new SimplePage();
        TabPanelBehavior panel = page.Tabs1.TabPanels.Value[3];
        panel.Populated.Register();
        panel.HeaderTab.Reference.Click();
        panel.Populated.Wait(3);
        panel.Invalidate();

        Assert.AreEqual(DynamicContent, page.Elements.Find(IdRegexOptions.None, string.Format("^{0}$", panel.BehaviorID)).GetAttributes().InnerText);
    }

    [WebTestMethod]
    public void ChangeTabWithBottomHeaders()
    {
        SimplePage page = new SimplePage();
        ChangeTabPanel(page.Tabs2, 0, 1);
    }

    /// <summary>
    /// Verify the active tab and change it to be a new tab.
    /// </summary>
    /// <param name="tabs"></param>
    /// <param name="activeTabIndex"></param>
    /// <param name="newActiveTabIndex"></param>
    private void ChangeTabPanel(TabContainerBehavior tabs, int activeTabIndex, int newActiveTabIndex)
    {
        Assert.AreEqual(activeTabIndex, tabs.ActiveTabIndex.Value);
        TabPanelBehavior panel = tabs.TabPanels.Value[newActiveTabIndex];
        panel.Click.Register();
        panel.HeaderTab.Reference.Click();
        panel.Click.Wait(3);
        panel.Active.Invalidate();
        Assert.IsTrue(panel.Active.Value);
    }
}