// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.SlideShow;

/// <summary>
/// Ensure that updating the context key resets the SlideShow correctly.
/// </summary>
/// <TestSuite>
///   <Path>SlideShow\ContextKey.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.SlideShowBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.SlideShow.ContextKeyPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("SlideShow.ContextKey")]
public class SlideShow_ContextKey : AjaxControlToolkit.Testing.Client.SlideShow.SlideShow_Common
{
    [WebTestMethod]
    public void ChangeContextKey()
    {
        ContextKeyPage page = new ContextKeyPage();
        Assert.AreEqual("Venice", page.SlideShowExtender.ContextKey.Value);
        Assert.StringEndsWith(page.SlideShowExtender.CurrentImagePath, "Venice1.jpg");
        page.ExecuteScript("updateSlideShow('Positano');");
        page.SlideShowExtender.ContextKey.Invalidate();
        page.SlideShowExtender.SlideChanged.Register();
        Assert.AreEqual("Positano", page.SlideShowExtender.ContextKey.Value);
        Assert.StringEndsWith(page.SlideShowExtender.CurrentImagePath, "Positano1.jpg");
        page.SlideShowExtender.ClickNext();
        page.SlideShowExtender.SlideChanged.Wait(2);
        Assert.StringEndsWith(page.SlideShowExtender.CurrentImagePath, "Positano2.jpg");
        page.ExecuteScript("updateSlideShow('Capri')");
        page.SlideShowExtender.ContextKey.Invalidate();
        Assert.AreEqual("Capri", page.SlideShowExtender.ContextKey.Value);
        Assert.StringEndsWith(page.SlideShowExtender.CurrentImagePath, "Capri1.jpg");
    }
}