// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Drawing;
using System.Collections.Generic;
using System.Web.UI.WebControls;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;

namespace AjaxControlToolkit.Testing.Client.RoundedCorners
{
    /// <summary>
    /// Common RoundedCorners tests
    /// </summary>
    /// <TestSuite>
    ///   <ComponentType>AjaxControlToolkit.Testing.Client.RoundedCornersBehavior</ComponentType>
    /// </TestSuite>
    [WebTestTag("RoundedCorners")]
    public abstract class RoundedCorners_Common
    {
        public abstract IEnumerable<RoundedCornersBehavior> RoundedCornersBehaviors
        {
            get;
        }

        [WebTestMethod]
        public void Common_InitialState()
        {
            foreach (RoundedCornersBehavior behavior in RoundedCornersBehaviors)
            {
                Assert.AreEqual(2 * behavior.Radius.Value, behavior.Element.ChildElements.Count - 1);
            }
        }

        [WebTestMethod]
        [WebTestTag("Smoke")]
        public void Common_PropertyChange()
        {
            foreach (RoundedCornersBehavior behavior in RoundedCornersBehaviors)
            {
                int newRadius = behavior.Radius.Value * 3;
                Color newColor = Color.Red;
                behavior.Color.Value = newColor.Name;
                behavior.Radius.Value = newRadius;
                behavior.Element.ChildElements.Refresh();
                behavior.Color.Invalidate();
                Assert.AreEqual(2 * newRadius, behavior.Element.ChildElements.Count - 1);
                Assert.AreEqual(newColor, behavior.Color.Reference.Value);
            }
        }

        [WebTestMethod]
        public void Common_AddBorder()
        {
            foreach (RoundedCornersBehavior behavior in RoundedCornersBehaviors)
            {
                behavior.Radius.Value = 2;
                behavior.Element.ChildElements.Refresh();
                behavior.BorderColor.Value = "Black";
                foreach (HtmlElement element in behavior.Element.ChildElements)
                {
                    HtmlElementAttributeReader attributes = element.GetAttributes();
                    if (attributes.Get<bool>("__roundedDiv") && !attributes.Get<bool>("__roundedDivNoBorder"))
                    {
                        Assert.AreEqual(BorderStyle.Solid, attributes.Style.BorderLeft.Style);
                    }
                }
            }
        }
    }
}
