// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.Rating;

/// <summary>
/// Ensure that rating control works fine when autopostback is set to true
/// </summary>
/// <TestSuite>
///   <Path>Rating\AutoPostBack.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.RatingBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.Rating.AutoPostBackPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("Rating.AutoPostBack")]
public class Rating_AutoPostBack : AjaxControlToolkit.Testing.Client.Rating.Rating_Common
{
    public override IEnumerable<RatingBehavior> RatingControls
    {
        get
        {
            yield return new AutoPostBackPage().Rating5_RatingExtender;
        }
    }

    [WebTestMethod]
    public void ValidateAutoPostbackSetToTrue()
    {
        AutoPostBackPage page = new AutoPostBackPage();
        RatingBehavior rating = page.Rating5_RatingExtender;
        Assert.AreEqual(true, rating.AutoPostBack.Value);
        rating.ClickRating(rating.MaxRating.Value - 1, true);
    }
}