// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.Popup;

/// <summary>
/// Ensure that the popup shows and hides as expected
/// </summary>
/// <TestSuite>
///   <Path>Popup\ShowHidePopup.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.PopupBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.Popup.ShowHidePopupPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("Popup.ShowHidePopup")]
public class Popup_ShowHidePopup : AjaxControlToolkit.Testing.Client.Popup.Popup_Common
{
    public override IEnumerable<PopupBehavior> Popups
    {
        get 
        {
            yield return new ShowHidePopupPage().PopupExtender;
        }
    }

    [WebTestMethod]
    public void ShowHidePopup()
    {
        ShowHidePopupPage page = new ShowHidePopupPage();
        PopupBehavior popup = page.PopupExtender;
        Assert.IsTrue(popup.IsHidden);
        popup.Show();
        popup.Hide();
    }
}