// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.NumericUpDown;

/// <summary>
/// Make sure that NumericUpDown works fine with RefValues set.
/// </summary>
/// <TestSuite>
///   <Path>NumericUpDown\RefValuesTest.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.NumericUpDownBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.NumericUpDown.RefValuesTestPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("NumericUpDown.RefValuesTest")]
public class NumericUpDown_RefValuesTest : AjaxControlToolkit.Testing.Client.NumericUpDown.NumericUpDown_Common
{
    [WebTestMethod]
    public void RefValues()
    {
        RefValuesTestPage page = new RefValuesTestPage();

        string[] refValues = page.NumericUpDownExtender2.RefValues.Value.Split(';');
        
        int currentValue = 2;
        for (int j = currentValue; j < refValues.Length; j++)
        {
            Assert.AreEqual(refValues[j], page.TextBox2.GetAttributes().Value);
            page.NumericUpDownExtender2.ClickUp();
        }
        Assert.AreEqual(refValues[refValues.Length - 1], page.TextBox2.GetAttributes().Value);

        for (int j = refValues.Length - 1; j >= 0; j--)
        {
            Assert.AreEqual(refValues[j], page.TextBox2.GetAttributes().Value);
            page.NumericUpDownExtender2.ClickDown();
        }
        Assert.AreEqual(refValues[0], page.TextBox2.GetAttributes().Value);

    }
}