// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.MutuallyExclusiveCheckBox;

/// <summary>
/// Test two sets of mutually exclusive check box extenders to make sure that the key
/// value determines the exclusiveness.
/// </summary>
/// <TestSuite>
///   <Path>MutuallyExclusiveCheckBox\KeysExclusiveness.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.MutuallyExclusiveCheckBoxBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.MutuallyExclusiveCheckBox.KeysExclusivenessPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("MutuallyExclusiveCheckBox.KeysExclusiveness")]
public class MutuallyExclusiveCheckBox_KeysExclusiveness : AjaxControlToolkit.Testing.Client.MutuallyExclusiveCheckBox.MutuallyExclusiveCheckBox_Common
{
    public override IEnumerable<MutuallyExclusiveCheckBoxBehavior> MutuallyExclusiveCheckBoxes
    {
        get 
        {
            KeysExclusivenessPage page = new KeysExclusivenessPage();
            yield return page.A0Ext;
            yield return page.A1Ext;
            yield return page.B0Ext;
            yield return page.B1Ext;
        }
    }

    [WebTestMethod]
    public void ExclusivenessTest()
    {
        KeysExclusivenessPage page = new KeysExclusivenessPage();
        // make sure that checking in one set does not affect the other
        page.A0Ext.AssertNoneChecked();
        page.B0Ext.AssertNoneChecked();
        page.A0Ext.SelectCheckBox();
        page.A0Ext.AssertOneChecked();
        page.B0Ext.AssertNoneChecked();
    }
}