using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.MaskedEdit;

/// <summary>
/// Summary description for MaskedEditScenario
/// </summary>
public class MaskedEditScenario
{

    /// <summary>
    /// MaskedEdit
    /// </summary>
    public MaskedEditBehavior MaskedEdit
    {
        get { return _maskedEdit; }
    }
    private MaskedEditBehavior _maskedEdit;

    /// <summary>
    /// Mask
    /// </summary>
    public string Mask
    {
        get { return _mask; }
    }
    private string _mask;

    /// <summary>
    /// Validator
    /// </summary>
    public HtmlElement Validator
    {
        get { return _validator; }
    }
    private HtmlElement _validator;


    public MaskedEditScenario(MaskedEditBehavior maskedEdit, string mask, HtmlElement validator)
    {
        Assert.IsNotNull(maskedEdit);
        _maskedEdit = maskedEdit;
        _mask = mask;
        _validator = validator;
    }
}
