// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.DropDown;

/// <summary>
/// SampleWebSite scenario
/// </summary>
/// <TestSuite>
///   <Path>DropDown\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.DropDownBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.DropDown.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("DropDown.Sample")]
[WebTestTag("SampleWebSite")]
public class DropDown_Sample : DropDown_Common
{
    public override IEnumerable<DropDownBehavior> DropDownBehaviors
    {
        get { yield return (new SamplePage()).DDE; }
    }

    [WebTestMethod]
    public void ClickListItems()
    {
        SamplePage page = new SamplePage();

        ClickListItem(page.DDE, page.Option3, page.lblSelection, "You selected Dry Fruit.");
        ClickListItem(page.DDE, page.Option1, page.lblSelection, "You selected Mocha Blast.");
    }

    protected void ClickListItem(DropDownBehavior behavior, HtmlAnchorElement option, HtmlElement label, string text)
    {
        behavior.HoverBehavior.HoverOver();
        DispatchEvent(behavior.DropWrapper, HtmlEventName.Click);
        behavior.AssertOpen(true);
        behavior.HoverBehavior.HoverOut();
        option.Click();
        Common.Wait(behavior.Page, 3, delegate() { Assert.AreEqual(text, label.GetAttributes().InnerText); return true; });
        behavior.AssertClosed();
    }
}
