// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System.Collections.Generic;
using System.Drawing;
using AjaxControlToolkit.Testing.Client.DragPanel;
using Microsoft.Web.Testing;

/// <summary>
/// SampleWebSite scenario
/// </summary>
/// <TestSuite>
///   <Path>DragPanel\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.DragPanelBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.DragPanel.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("DragPanel.Sample")]
[WebTestTag("SampleWebSite")]
public class DragPanel_Sample : DragPanel_Common
{
    public override IEnumerable<DragPanelScenario> DragPanelScenarios
    {
        get { yield return new DragPanelScenario(new SamplePage().DragPanelExtender1, new Point(5, 61)); }
    }
}