// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.CascadingDropDown;

/// <summary>
/// Typical CascadingDropDown scenarios
/// </summary>
/// <TestSuite>
///   <Path>CascadingDropDown\Typical.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.CascadingDropDownBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.CascadingDropDown.TypicalPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("CascadingDropDown.Typical")]
public class CascadingDropDown_Typical : AjaxControlToolkit.Testing.Client.CascadingDropDown.CascadingDropDown_Common
{
    [WebTestMethod]
    public void InitialState()
    {
        TypicalPage page = new TypicalPage();
        RegisterForSelectionChanged(page.CascadingDropDown1);
        WaitForPopulation(page.CascadingDropDown1);

        page.CascadingDropDown1.AssertPopulationCorrect(0, _optionInformationsMake);
        AssertDropDownsDisabled(page.CascadingDropDown2, page.CascadingDropDown3, page.CascadingDropDown4);
    }

    [WebTestMethod]
    [WebTestTag("Smoke")]
    public void Selections()
    {
        TypicalPage page = new TypicalPage();
        RegisterForSelectionChanged(page.CascadingDropDown1, page.CascadingDropDown2, page.CascadingDropDown3, page.CascadingDropDown4);
        WaitForPopulation(page.CascadingDropDown1);

        page.CascadingDropDown1.SetSelectedIndex(3, page.CascadingDropDown2, page.CascadingDropDown3, page.CascadingDropDown4);
        WaitForPopulation(page.CascadingDropDown2);
        page.CascadingDropDown1.AssertPopulationCorrect(3, _optionInformationsMake);
        page.CascadingDropDown2.AssertPopulationCorrect(0, _optionInformationsMakeBmwModel);
        AssertDropDownsDisabled(page.CascadingDropDown3, page.CascadingDropDown4);

        page.CascadingDropDown2.SetSelectedIndex(2, page.CascadingDropDown3, page.CascadingDropDown4);
        WaitForPopulation(page.CascadingDropDown3, page.CascadingDropDown4);
        page.CascadingDropDown1.AssertPopulationCorrect(3, _optionInformationsMake);
        page.CascadingDropDown2.AssertPopulationCorrect(2, _optionInformationsMakeBmwModel);
        page.CascadingDropDown3.AssertPopulationCorrect(0, _optionInformationsMakeBmwModel5series);
        page.CascadingDropDown4.AssertPopulationCorrect(2, _optionInformationsMakeBmwModel5series);

        page.CascadingDropDown3.SetSelectedIndex(1);
        page.CascadingDropDown3.AssertPopulationCorrect(1, _optionInformationsMakeBmwModel5series);

        page.CascadingDropDown1.SetSelectedIndex(2, page.CascadingDropDown2, page.CascadingDropDown3, page.CascadingDropDown4);
        WaitForPopulation(page.CascadingDropDown2);
        page.CascadingDropDown1.AssertPopulationCorrect(2, _optionInformationsMake);
        page.CascadingDropDown2.AssertPopulationCorrect(0, _optionInformationsMakeAudiModel);
        AssertDropDownsDisabled(page.CascadingDropDown3, page.CascadingDropDown4);
    }

    [WebTestMethod]
    [WebTestFailureTag(Browsers.Safari, "TODO: Investigate.")]
    public void Postback()
    {
        TypicalPage page = new TypicalPage();
        RegisterForSelectionChanged(page.CascadingDropDown1, page.CascadingDropDown2, page.CascadingDropDown3, page.CascadingDropDown4);
        WaitForPopulation(page.CascadingDropDown1);

        page.CascadingDropDown1.SetSelectedIndex(3, page.CascadingDropDown2, page.CascadingDropDown3, page.CascadingDropDown4);
        WaitForPopulation(page.CascadingDropDown2);

        page.CascadingDropDown2.SetSelectedIndex(2, page.CascadingDropDown3, page.CascadingDropDown4);
        WaitForPopulation(page.CascadingDropDown3, page.CascadingDropDown4);

        page.Button.Click(true);
        RegisterForSelectionChanged(page.CascadingDropDown1, page.CascadingDropDown2, page.CascadingDropDown3, page.CascadingDropDown4);
        WaitForPopulation(page.CascadingDropDown1, page.CascadingDropDown2, page.CascadingDropDown3, page.CascadingDropDown4);
        Assert.AreEqual("::", page.Label3.GetAttributes().InnerText);
        Assert.AreEqual("Banana (value):Banana (value):Banana", page.Label4.GetAttributes().InnerText);
        page.CascadingDropDown1.AssertPopulationCorrect(3, _optionInformationsMake);
        page.CascadingDropDown2.AssertPopulationCorrect(2, _optionInformationsMakeBmwModel);
        page.CascadingDropDown3.AssertPopulationCorrect(0, _optionInformationsMakeBmwModel5series);
        page.CascadingDropDown4.AssertPopulationCorrect(2, _optionInformationsMakeBmwModel5series);

        page.CascadingDropDown2.SetSelectedIndex(0, page.CascadingDropDown3, page.CascadingDropDown4);
        page.Button.Click(true);
        Assert.AreEqual("::", page.Label3.GetAttributes().InnerText);
        Assert.AreEqual("::", page.Label4.GetAttributes().InnerText);

        page.CascadingDropDown2.SetSelectedIndex(1, page.CascadingDropDown3, page.CascadingDropDown4);
        page.CascadingDropDown2.SetSelectedIndex(0, page.CascadingDropDown3, page.CascadingDropDown4);
        page.Button.Click(true);
        Assert.AreEqual("::", page.Label3.GetAttributes().InnerText);
        Assert.AreEqual("::", page.Label4.GetAttributes().InnerText);
    }
}
