using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;

namespace AjaxControlToolkit.Testing.Client.AutoComplete
{
	/// <summary>
	/// Wrapper for OfferOnlyCurrentWordPage/TextValuePair.aspx
	/// </summary>
	public partial class OfferOnlyCurrentWordPage : ToolkitTestPage
	{
		/// <summary>
		/// Path to the page
		/// </summary>
		public override string Path
		{
            get { return @"AutoComplete/OfferOnlyCurrentWord.aspx"; }
		}

		/// <summary>
		/// Wrapper for AjaxControlToolkit.AutoCompleteExtender "autoCompleteBehavior"
		/// </summary>
		/// <WrapperProperty ClientID="Behavior" Type="AjaxControlToolkit.AutoCompleteExtender" />
		public AutoCompleteBehavior Behavior
		{
			get { return autoCompleteBehavior; }
			set { autoCompleteBehavior = value; }
		}
		private AutoCompleteBehavior autoCompleteBehavior;

		/// <summary>
		/// Wrapper for System.Web.UI.WebControls.TextBox "tbOfferOnlyCurrentWordTestingObject"
		/// </summary>
		/// <WrapperProperty ClientID="MyTextBox" Type="System.Web.UI.WebControls.TextBox" />
		public HtmlInputElement MyTextBox
		{
			get { return tbOfferOnlyCurrentWordTestingObject; }
			set { tbOfferOnlyCurrentWordTestingObject = value; }
		}
		private HtmlInputElement tbOfferOnlyCurrentWordTestingObject;

		/// <summary>
		/// Find references to the page's controls
		/// </summary>
		public override void FindControls()
		{
			base.FindControls();
			this.tbOfferOnlyCurrentWordTestingObject = Elements.Find("tbOfferOnlyCurrentWordTestingObject") as HtmlInputElement;
			Assert.IsNotNull(this.tbOfferOnlyCurrentWordTestingObject, "Could not find Microsoft.Web.Testing.UI.HtmlInputElement \"tbOfferOnlyCurrentWordTestingObject\"!");
			this.autoCompleteBehavior = new AutoCompleteBehavior(this.tbOfferOnlyCurrentWordTestingObject, "autoCompleteBehavior", this);
		}
	}
}