// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.Accordion;

/// <summary>
/// Basic Accordion tests
/// </summary>
/// <TestSuite>
///   <Path>Accordion\Simple.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.AccordionBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.Accordion.SimplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("Accordion.Simple")]
public class Accordion_Simple : Accordion_Common
{
    /// <summary>
    /// Accordion behaviors on the page along with the number of panes in
    /// each Accordion and a button used to cause a postback or partial
    /// postback
    /// </summary>
    public override IEnumerable<AccordionScenario> AccordionScenarios
    {
        get
        {
            SimplePage page = new SimplePage();
            yield return new AccordionScenario(page.Accordion, 10, page.Button);
        }
    }

    /// <summary>
    /// Override ChangeSelectedIndex test to make it a smoke test for
    /// the simple case only
    /// </summary>
    [WebTestMethod]
    [WebTestTag("Smoke")]
    public override void Common_ChangeSelectedIndex()
    {
        base.Common_ChangeSelectedIndex();
    }
    
    /// <summary>
    /// Verify that the selected index is preserved on postback
    /// </summary>
    [WebTestMethod]
    [WebTestFailureTag(Browsers.All, "Work Item #???: The selected style is not cleared on the postback and is still applied to the old pane (only happens when HeaderSelectedCssClass is defined).")]
    public override void Common_IndexPreservedOnPostback()
    {
        base.Common_IndexPreservedOnPostback();
    }
}