// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using AjaxControlToolkit;
using AjaxControlToolkit.Testing.Client;

namespace AjaxControlToolkit.Testing.Client.Accordion
{
    /// <summary>
    /// Databound Accordion tests
    /// </summary>
    public partial class Databound : Page
    {
        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);

            if (!IsPostBack)
            {
                Dictionary<string, string> values = new Dictionary<string, string>();
                values["A"] = "This is the value for A";
                values["B"] = "This is the value for B";
                values["C"] = "This is the value for C";
                values["D"] = "This is the value for D";
                Accordion.DataSource = values;
                Accordion.DataBind();
            }
        }

        protected void Postback_Click(object sender, EventArgs e)
        {
        }
    }
}