// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using AjaxControlToolkit;
using AjaxControlToolkit.Testing.Client;

namespace AjaxControlToolkit.Testing.Client.PopupControl
{
    /// <summary>
    /// PopupControl in an UpdatePanel
    /// </summary>
    public partial class UpdatePanel : Page
    {
        protected void Commit_Click(object sender, EventArgs e)
        {
            PopupControl.Commit(PopupControl_Common.CommitText);
        }
        protected void Clear_Click(object sender, EventArgs e)
        {
            PopupControl.Commit("");
        }
        protected void Cancel_Click(object sender, EventArgs e)
        {
            PopupControl.Cancel();
        }
        protected void CommitCancel_Click(object sender, EventArgs e)
        {
            PopupControl.Commit(PopupControl_Common.CommitText);
            PopupControl.Cancel();
        }
        protected void CancelCommit_Click(object sender, EventArgs e)
        {
            PopupControl.Cancel();
            PopupControl.Commit(PopupControl_Common.CommitText);
        }
    }
}
