// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using AjaxControlToolkit;
using AjaxControlToolkit.Testing.Client;

namespace AjaxControlToolkit.Testing.Client.AutoComplete
{
    /// <summary>
    /// Have characters less that minimum number of characters required in the textbox and make sure you get no suggestions
    /// </summary>
    public partial class Options : Page
    {
        public Options()
        { }

        [System.Web.Services.WebMethod]
        [System.Web.Script.Services.ScriptMethod]
        public static string[] GetWords(string prefixText, int count)
        {
            string[] suggestions = new string[count];
            for (int i = 0; i < count; ++i)
            {
                suggestions[i] = prefixText + i;
            }
            return suggestions;
        }
    }
}