// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.ValidatorCallout;

/// <summary>
/// ValidatorCallout for a CompareValidator
/// </summary>
/// <TestSuite>
///   <Path>ValidatorCallout\CompareValidator.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.ValidatorCalloutBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.ValidatorCallout.CompareValidatorPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("ValidatorCallout.CompareValidator")]
public class ValidatorCallout_CompareValidator : AjaxControlToolkit.Testing.Client.ValidatorCallout.ValidatorCallout_Common
{
    public override IEnumerable<ValidatorCalloutScenario> ValidatorCalloutScenarios
    {
        get
        {
            CompareValidatorPage page = new CompareValidatorPage();
            yield return new ValidatorCalloutScenario(page.ValidatorCalloutCompare, page.TextBoxCompare, "5", "15", page.Button, false, true);
        }
    }
}
