// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;

namespace AjaxControlToolkit.Testing.Client.TextboxWatermark
{
    public class TextboxWatermarkScenario
    {
        public TextboxWatermarkBehavior Behavior
        {
            get { return _behavior; }
        }
        private TextboxWatermarkBehavior _behavior;

        public HtmlInputElement Button
        {
            get { return _button; }
        }
        private HtmlInputElement _button;

        public HtmlElement Label
        {
            get { return _label; }
        }
        private HtmlElement _label;

        public string TextFormat
        {
            get { return _textFormat; }
        }
        private string _textFormat;

        public string EmptyText
        {
            get { return _emptyText; }
        }
        private string _emptyText;

        private bool _insideUpdatePanel;

        public TextboxWatermarkScenario(TextboxWatermarkBehavior behavior, HtmlInputElement button, HtmlElement label, string textFormat, string EmptyText, bool insideUpdatePanel)
        {
            Assert.IsNotNull(behavior);
            Assert.IsNotNull(button);
            Assert.IsNotNull(label);
            Assert.IsNotNull(textFormat);
            Assert.IsNotNull(EmptyText);
            _behavior = behavior;
            _button = button;
            _label = label;
            _textFormat = textFormat;
            _emptyText = EmptyText;
            _insideUpdatePanel = insideUpdatePanel;
            if (_insideUpdatePanel)
            {
                behavior.Page.RegisterForPartialPostback();
            }
        }

        public void DoPostback()
        {
            Button.Click(!_insideUpdatePanel);
            if (_insideUpdatePanel)
            {
                Behavior.Page.WaitForPartialPostback();
            }
        }
    }
}
