// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.Rating;

/// <summary>
/// SampleWebSite scenario
/// </summary>
/// <TestSuite>
///   <Path>Rating\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.RatingBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.Rating.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("Rating.Sample")]
[WebTestTag("SampleWebSite")]
public class Rating_Sample : AjaxControlToolkit.Testing.Client.Rating.Rating_Common
{
    public override IEnumerable<RatingBehavior> RatingControls
    {
        get 
        {
            yield return new SamplePage().ThaiRating_RatingExtender;
        }
    }
}