// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.MultiHandleSlider;

/// <summary>
/// Slider test to make sure that values set in the bound textbox are reflected
/// by the slider and vice versa.
/// </summary>
/// <TestSuite>
///   <Path>MultiHandleSlider\BoundTextBox.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.MultiHandleSliderBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.MultiHandleSlider.BoundTextBoxPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("MultiHandleSlider.BoundTextBox")]
public class MultiHandleSlider_BoundTextBox : MultiHandleSlider_Common
{
    public override IEnumerable<MultiHandleSliderBehavior> BackCompatSliders
    {
        get 
        {
            yield return new BoundTextBoxPage().SliderExtender1;
        }
    }

    [WebTestMethod]
    public void AssertBoundValuesInSync()
    {
        BoundTextBoxPage page = new BoundTextBoxPage();
        MultiHandleSliderBehavior slider = page.SliderExtender1;
        slider.BoundControlValue = 50;
        slider.AssertSliderValue(50);

        // minimum - ensure binding
        slider.BoundControlValue = -10;
        slider.AssertSliderValue(slider.Minimum.Value);

        // maximum - ensure binding
        slider.BoundControlValue = 11110;
        slider.AssertSliderValue(slider.Maximum.Value);
    }

    [WebTestMethod]
    public void ValueMaintainedAfterPostback()
    {
        BoundTextBoxPage page = new BoundTextBoxPage();
        MultiHandleSliderBehavior slider = page.SliderExtender1;
        slider.BoundControlValue = 50;
        page.btnPostBack.Click(true);
        slider.AssertSliderValue(50);

        // minimum - ensure binding
        slider.BoundControlValue = -10;
        page.btnPostBack.Click(true);
        slider.AssertSliderValue(slider.Minimum.Value);

        // maximum - ensure binding
        slider.BoundControlValue = 11110;
        page.btnPostBack.Click(true);
        slider.AssertSliderValue(slider.Maximum.Value);
    }


}