// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.ModalPopup;

/// <summary>
/// Show and hide the ModalPopup programmatically from the client and server side.
/// </summary>
/// <TestSuite>
///   <Path>ModalPopup\ProgrammaticShowHide.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.ModalPopupBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.ModalPopup.ProgrammaticShowHidePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("ModalPopup.ProgrammaticShowHide")]
public class ModalPopup_ProgrammaticShowHide : AjaxControlToolkit.Testing.Client.ModalPopup.ModalPopup_Common
{
    public override IEnumerable<ModalPopupBehavior> ModalPopups
    {
        get
        {
            yield return new ProgrammaticShowHidePage().ModalPopupExtender1;
        }
    }
    
    [WebTestMethod]
    public void ShowHideFromServerSide()
    {
        ProgrammaticShowHidePage page = new ProgrammaticShowHidePage();
        page.ShowViaServer.Click(true, true);
        Assert.IsFalse(page.ModalPopupExtender1.IsHidden);
        page.HideViaServer.Click(true, true);
        Assert.IsTrue(page.ModalPopupExtender1.IsHidden);
    }

    [WebTestMethod]
    public void ShowHideFromClientSide()
    {
        ProgrammaticShowHidePage page = new ProgrammaticShowHidePage();
        page.ExecuteScript(string.Format("{0}.show()", page.ModalPopupExtender1.BehaviorReferenceExpression));
        Assert.IsFalse(page.ModalPopupExtender1.IsHidden);
        page.ExecuteScript(string.Format("{0}.hide()", page.ModalPopupExtender1.BehaviorReferenceExpression));
        Assert.IsTrue(page.ModalPopupExtender1.IsHidden);
    }

    [WebTestMethod]
    public void MultipleShowFromServer()
    {
        ProgrammaticShowHidePage page = new ProgrammaticShowHidePage();
        page.MultipleShowsViaServer.Click(true, true);
        Assert.IsFalse(page.ModalPopupExtender1.IsHidden);
        page.HideViaServer.Click(true, true);
        Assert.IsTrue(page.ModalPopupExtender1.IsHidden);
    }

    [WebTestMethod]
    public void ShowViaServerHideViaClient()
    {
        ProgrammaticShowHidePage page = new ProgrammaticShowHidePage();
        page.ShowViaServer.Click(true, true);
        Assert.IsFalse(page.ModalPopupExtender1.IsHidden);
        page.ExecuteScript(string.Format("{0}.hide()", page.ModalPopupExtender1.BehaviorReferenceExpression));
        Assert.IsTrue(page.ModalPopupExtender1.IsHidden);
    }

    [WebTestMethod]
    public void ShowViaClientHideViaServer()
    {
        ProgrammaticShowHidePage page = new ProgrammaticShowHidePage();
        page.ExecuteScript(string.Format("{0}.show()", page.ModalPopupExtender1.BehaviorReferenceExpression));
        Assert.IsFalse(page.ModalPopupExtender1.IsHidden);
        page.HideViaServer.Click(true, true);
        Assert.IsTrue(page.ModalPopupExtender1.IsHidden);
    }
}