// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// AjaxControlToolkit.ModalPopupExtender Model
    /// </summary>
    /// <TestComponent Name="ModalPopup">
    ///   <ToolkitType>AjaxControlToolkit.ModalPopupExtender</ToolkitType>
    ///   <CommonTestSuite>AjaxControlToolkit.Testing.Client.ModalPopup.ModalPopup_Common</CommonTestSuite>
    /// </TestComponent>
    public class ModalPopupBehavior : Behavior<HtmlElement>
    {
        /// <summary>
        /// PopupControl
        /// </summary>
        public ReferenceBehaviorProperty<HtmlElement> PopupControl
        {
            get 
            {
                return _popupControl;
            }
        }
        private ReferenceBehaviorProperty<HtmlElement> _popupControl;

        /// <summary>
        /// BackgroundDiv
        /// </summary>
        public ReferenceBehaviorProperty<HtmlElement> BackgroundDiv
        {
            get { return _backgroundDiv; }
        }
        private ReferenceBehaviorProperty<HtmlElement> _backgroundDiv;

        /// <summary>
        /// BackgroundCssClass
        /// </summary>
        public BehaviorProperty<string> BackgroundCssClass
        {
            get { return _backgroundCssClass; }
        }
        private BehaviorProperty<string> _backgroundCssClass;

        /// <summary>
        /// OkControl
        /// </summary>
        public ReferenceBehaviorProperty<HtmlInputElement> OkControl
        {
            get { return _okControl; }
        }
        private ReferenceBehaviorProperty<HtmlInputElement> _okControl;

        /// <summary>
        /// CancelControl
        /// </summary>
        public ReferenceBehaviorProperty<HtmlInputElement> CancelControl
        {
            get { return _cancelControl; }
        }
        private ReferenceBehaviorProperty<HtmlInputElement> _cancelControl;

        /// <summary>
        /// OnOkScript
        /// </summary>
        public BehaviorProperty<string> OnOkScript
        {
            get { return _onOkScript; }
        }
        private BehaviorProperty<string> _onOkScript;

        /// <summary>
        /// OnCancelScript
        /// </summary>
        public BehaviorProperty<string> OnCancelScript
        {
            get { return _onCancelScript; }
        }
        private BehaviorProperty<string> _onCancelScript;

        /// <summary>
        /// X
        /// </summary>
        public BehaviorProperty<int> X
        {
            get { return _x; }
        }
        private BehaviorProperty<int> _x;

        /// <summary>
        /// Y
        /// </summary>
        public BehaviorProperty<int> Y
        {
            get { return _y; }
        }
        private BehaviorProperty<int> _y;

        /// <summary>
        /// Drag
        /// </summary>
        public BehaviorProperty<bool> Drag
        {
            get { return _drag; }
        }
        private BehaviorProperty<bool> _drag;

        /// <summary>
        /// PopupDragHandleControlID
        /// </summary>
        public ReferenceBehaviorProperty<HtmlElement> PopupDragHandleControl
        {
            get { return _popupDragHandleControl; }
        }
        private ReferenceBehaviorProperty<HtmlElement> _popupDragHandleControl;

        /// <summary>
        /// DropShadow
        /// </summary>
        public BehaviorProperty<bool> DropShadow
        {
            get { return _dropShadow; }
        }
        private BehaviorProperty<bool> _dropShadow;

        /// <summary>
        /// DynamicControl
        /// </summary>
        public ReferenceBehaviorProperty<HtmlElement> DynamicControl
        {
            get { return _dynamicControl; }
        }
        private ReferenceBehaviorProperty<HtmlElement> _dynamicControl;

        /// <summary>
        /// DynamicContextKey
        /// </summary>
        public BehaviorProperty<string> DynamicContextKey
        {
            get { return _dynamicContextKey; }
        }
        private BehaviorProperty<string> _dynamicContextKey;

        /// <summary>
        /// DynamicServicePath
        /// </summary>
        public BehaviorProperty<string> DynamicServicePath
        {
            get { return _dynamicServicePath; }
        }
        private BehaviorProperty<string> _dynamicServicePath;

        /// <summary>
        /// DynamicServiceMethod
        /// </summary>
        public BehaviorProperty<string> DynamicServiceMethod
        {
            get { return _dynamicServiceMethod; }
        }
        private BehaviorProperty<string> _dynamicServiceMethod;

        /// <summary>
        /// CacheDynamicResults
        /// </summary>
        public BehaviorProperty<bool> CacheDynamicResults
        {
            get { return _cacheDynamicResults; }
        }
        private BehaviorProperty<bool> _cacheDynamicResults;

        /// <summary>
        /// AjaxControlToolkit.ModalPopupExtender Model
        /// </summary>
        /// <param name="element">Target element</param>
        /// <param name="behaviorID">Behavior ID</param>
        /// <param name="page">Page Model</param>
        public ModalPopupBehavior(HtmlElement element, string behaviorID, ToolkitTestPage page)
            : base(element, behaviorID, page)
        {
            _popupControl = ReferenceBehaviorProperty<HtmlElement>.CreateField(this, "id", "{0}._foregroundElement");
            _backgroundDiv = ReferenceBehaviorProperty<HtmlElement>.CreateField(this, "id", "{0}._backgroundElement");
            _backgroundCssClass = BehaviorProperty<string>.CreateProperty(this, "BackgroundCssClass");
            _okControl = ReferenceBehaviorProperty<HtmlInputElement>.CreateProperty(this, "OkControlID");
            _cancelControl = ReferenceBehaviorProperty<HtmlInputElement>.CreateProperty(this, "CancelControlID");
            _onOkScript = BehaviorProperty<string>.CreateProperty(this, "OnOkScript");
            _onCancelScript = BehaviorProperty<string>.CreateProperty(this, "OnCancelScript");
            _x = BehaviorProperty<int>.CreateProperty(this, "X");
            _y = BehaviorProperty<int>.CreateProperty(this, "Y");
            _drag = BehaviorProperty<bool>.CreateProperty(this, "Drag");
            _popupDragHandleControl = ReferenceBehaviorProperty<HtmlElement>.CreateProperty(this, "PopupDragHandleControlID");
            _dropShadow = BehaviorProperty<bool>.CreateProperty(this, "DropShadow");
            _dynamicControl = ReferenceBehaviorProperty<HtmlElement>.CreateProperty(this, "dynamicControlID");
            _dynamicContextKey = BehaviorProperty<string>.CreateProperty(this, "dynamicContextKey");
            _dynamicServicePath = BehaviorProperty<string>.CreateProperty(this, "dynamicServicePath");
            _dynamicServiceMethod = BehaviorProperty<string>.CreateProperty(this, "dynamicServiceMethod");
            _cacheDynamicResults = BehaviorProperty<bool>.CreateProperty(this, "cacheDynamicResults");
        }

        public void ShowPopup()
        {
            this.Element.Click(false, false);
            Assert.IsFalse(this.IsHidden);
        }

        public void ClickOK()
        {
            this.OkControl.Reference.Click(false, false);
            Assert.IsTrue(this.IsHidden);
        }

        public void ClickCancel()
        {
            this.CancelControl.Reference.Click(false, false);
            Assert.IsTrue(this.IsHidden);
        }

        public bool IsHidden
        {
            get
            {
                HtmlStyle popupStyle = this.PopupControl.Reference.GetAttributes().Style;
                HtmlStyle backgroundStyle = this.BackgroundDiv.Reference.GetAttributes().Style;
                return (((popupStyle.Display == Display.None) || (popupStyle.Visibility == Visibility.Hidden)) &&
                    ((backgroundStyle.Display == Display.None) || (backgroundStyle.Visibility == Visibility.Hidden)));
            }
        }
    }
}