// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.MaskedEdit;

/// <summary>
/// SampleWebSite scenario
/// </summary>
/// <TestSuite>
///   <Path>MaskedEdit\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.MaskedEditBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.MaskedEdit.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("MaskedEdit.Sample")]
[WebTestTag("SampleWebSite")]
public class MaskedEdit_Sample : AjaxControlToolkit.Testing.Client.MaskedEdit.MaskedEdit_Common
{
    public override IEnumerable<MaskedEditScenario> MaskedEdits
    {
        get 
        { 
            SamplePage page = new SamplePage();
            yield return new MaskedEditScenario(page.MaskedEditExtender2, "$  _,___,___.__", page.MaskedEditValidator2);
            yield return new MaskedEditScenario(page.MaskedEditExtender3, "__:__:__ AM", page.MaskedEditValidator3);
            yield return new MaskedEditScenario(page.MaskedEditExtender5, "__/__/____", page.MaskedEditValidator5);
            yield return new MaskedEditScenario(page.MaskedEditExtender6, "__/__/____ __:__:__ AM", page.MaskedEditValidator6);
        }
    }
}