// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;

namespace AjaxControlToolkit.Testing.Client.MaskedEdit
{
    /// <summary>
    /// Common MaskedEdit tests
    /// </summary>
    /// <TestSuite>
    ///   <ComponentType>AjaxControlToolkit.Testing.Client.MaskedEditBehavior</ComponentType>
    /// </TestSuite>
    [WebTestTag("MaskedEdit")]
    public abstract class MaskedEdit_Common
    {
        public abstract IEnumerable<MaskedEditScenario> MaskedEdits
        {
            get;
        }

        /// <summary>
        /// Validate mask
        /// </summary>
        [WebTestMethod]
        [WebTestTag("Intermittent")] // TODO: ??? fails intermittently in IE for SamplePage Date and Time MaskedEdit Extender.
        public void Common_MaskOnFocusAndBlur()
        {
            foreach (MaskedEditScenario maskedEditScenario in MaskedEdits)
            {
                string maskOnBlur;
                if (maskedEditScenario.MaskedEdit.ClearMaskOnLostFocus.Value)
                {
                    maskOnBlur = string.Empty;
                }
                else
                {
                    maskOnBlur = maskedEditScenario.Mask;
                }
                Assert.AreEqual(maskOnBlur, maskedEditScenario.MaskedEdit.Element.GetAttributes().Value ?? string.Empty);
                maskedEditScenario.MaskedEdit.Element.Focus();
                Assert.AreEqual(maskedEditScenario.Mask, maskedEditScenario.MaskedEdit.Element.GetAttributes().Value);
                maskedEditScenario.MaskedEdit.Element.SetText(string.Empty, false);
                maskedEditScenario.MaskedEdit.Element.Blur();
                Assert.AreEqual(maskOnBlur, maskedEditScenario.MaskedEdit.Element.GetAttributes().Value ?? string.Empty);
            }
        }
    }
}