// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// AjaxControlToolkit.ListSearchExtender Model
    /// </summary>
    /// <TestComponent Name="ListSearch">
    ///   <ToolkitType>AjaxControlToolkit.ListSearchExtender</ToolkitType>
    ///   <CommonTestSuite>AjaxControlToolkit.Testing.Client.ListSearch.ListSearch_Common</CommonTestSuite>
    /// </TestComponent>
    public class ListSearchBehavior : Behavior<HtmlSelectElement>
    {
        /// <summary>
        /// PromptText
        /// </summary>
        public BehaviorProperty<string> PromptText
        {
            get { return _promptText; }
        }
        private BehaviorProperty<string> _promptText;

        /// <summary>
        /// PromptCssClass
        /// </summary>
        public BehaviorProperty<string> PromptCssClass
        {
            get { return _promptCssClass; }
        }
        private BehaviorProperty<string> _promptCssClass;

        /// <summary>
        /// PromptPosition
        /// </summary>
        public BehaviorProperty<ListSearchPromptPosition> PromptPosition
        {
            get { return _promptPosition; }
        }
        private BehaviorProperty<ListSearchPromptPosition> _promptPosition;

        /// <summary>
        /// PromptDivExists
        /// </summary>
        public BehaviorProperty<bool> PromptDivExists
        {
            get { return _promptDivExists; }
        }
        public BehaviorProperty<bool> _promptDivExists;

        /// <summary>
        /// QueryPattern
        /// </summary>
        public BehaviorProperty<ListSearchQueryPattern> QueryPattern
        {
            get { return _queryPattern; }
        }
        public BehaviorProperty<ListSearchQueryPattern> _queryPattern;

        /// <summary>
        /// QueryTimeout
        /// </summary>
        public BehaviorProperty<int> QueryTimeout
        {
            get { return _queryTimeout; }
        }
        public BehaviorProperty<int> _queryTimeout;

        /// <summary>
        /// IsSorted
        /// </summary>
        public BehaviorProperty<bool> IsSorted
        {
            get { return _isSorted; }
        }
        public BehaviorProperty<bool> _isSorted;

        /// <summary>
        /// PromptDiv
        /// </summary>
        public ReferenceBehaviorProperty<HtmlElement> PromptDiv
        {
            get { return _promptDiv; }
        }
        private ReferenceBehaviorProperty<HtmlElement> _promptDiv;

         ///<summary>
         ///PopupBehavior
         ///</summary>
        public PopupBehavior PopupBehavior
        {
            get
            {
                if (this._popupBehavior == null)
                {
                    _popupBehavior = new PopupBehavior(
                        _promptDiv.Reference,
                        this.BehaviorID + "_popupBehavior",
                        string.Format("{0}._popupBehavior", this.BehaviorReferenceExpression),
                        this.Page);
                }
                return _popupBehavior;
            }
        }
        private PopupBehavior _popupBehavior;

        /// <summary>
        /// AjaxControlToolkit.ListSearchExtender Model
        /// </summary>
        /// <param name="element">Target element</param>
        /// <param name="behaviorID">Behavior ID</param>
        /// <param name="page">Page Model</param>
        public ListSearchBehavior(HtmlSelectElement element, string behaviorID, ToolkitTestPage page)
            : base(element, behaviorID, page)
        {
            _promptText = BehaviorProperty<string>.CreateProperty(this, "promptText");
            _promptCssClass = BehaviorProperty<string>.CreateProperty(this, "promptCssClass");
            _promptPosition = BehaviorProperty<ListSearchPromptPosition>.CreateProperty(this, "promptPosition");
            _promptDivExists = BehaviorProperty<bool>.CreateCustomProperty(this, null, "null != {0}._promptDiv", "throw 'PromptDivExists property is read-only!'");
            _promptDiv = ReferenceBehaviorProperty<HtmlElement>.CreateField(this, "id", ReadStrategy.Demand, WriteStrategy.Immediate, "{0}._promptDiv");
            _queryPattern = BehaviorProperty<ListSearchQueryPattern>.CreateProperty(this, "queryPattern");
            _isSorted = BehaviorProperty<bool>.CreateProperty(this, "isSorted");
            _queryTimeout = BehaviorProperty<int>.CreateProperty(this, "queryTimeout");
        }
    }
}
