// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;

namespace AjaxControlToolkit.Testing.Client.DropShadow
{
    /// <summary>
    /// Common DropShadow tests
    /// </summary>
    /// <TestSuite>
    ///   <ComponentType>AjaxControlToolkit.Testing.Client.DropShadowBehavior</ComponentType>
    /// </TestSuite>
    [WebTestTag("DropShadow")]
    public abstract class DropShadow_Common
    {
        public abstract IEnumerable<DropShadowBehavior> DropShadows
        {
            get;
        }

        [WebTestMethod]
        [WebTestTag("Smoke")]
        public void Common_Bounds()
        {
            foreach (DropShadowBehavior dropShadow in DropShadows)
            {
                dropShadow.AssertBounds();
            }
        }

        [WebTestMethod]
        public void Common_ChangeWidth()
        {
            foreach (DropShadowBehavior dropShadow in DropShadows)
            {
                dropShadow.Width.Value += 5;
                dropShadow.Invalidate();
                dropShadow.AssertBounds();
            
                dropShadow.Width.Value = 0;
                dropShadow.Invalidate();
                dropShadow.AssertBounds();
            
                dropShadow.Width.Value = 8;
                dropShadow.Invalidate();
                dropShadow.AssertBounds();
            }
        }

        [WebTestMethod]
        public void Common_Opacity()
        {
            foreach (DropShadowBehavior dropShadow in DropShadows)
            {
                dropShadow.Opacity.Value = 0.4f;
                dropShadow.Invalidate();
                dropShadow.AssertBounds();
                Assert.AreEqual(0.4f, dropShadow.Opacity.Value);
            }
        }

        [WebTestMethod]
        public void Common_Rounded()
        {
            foreach (DropShadowBehavior dropShadow in DropShadows)
            {
                dropShadow.Rounded.Value = true;
                dropShadow.Invalidate();
                dropShadow.AssertBounds();
            }
        }

        [WebTestMethod]
        public void Common_RoundedWidth()
        {
            foreach (DropShadowBehavior dropShadow in DropShadows)
            {
                dropShadow.Rounded.Value = true;
                dropShadow.Invalidate();
                dropShadow.AssertBounds();
            
                dropShadow.Width.Value += 5;
                dropShadow.Invalidate();
                dropShadow.AssertBounds();
            
                dropShadow.Width.Value = 0;
                dropShadow.Invalidate();
                dropShadow.AssertBounds();
            
                dropShadow.Width.Value = 8;
                dropShadow.Invalidate();
                dropShadow.AssertBounds();
            }
        }

        [WebTestMethod]
        public void Common_RoundedRadius()
        {
            foreach (DropShadowBehavior dropShadow in DropShadows)
            {
                dropShadow.Rounded.Value = true;
                dropShadow.Invalidate();
                dropShadow.AssertBounds();

                dropShadow.Radius.Value += 5;
                dropShadow.Invalidate();
                dropShadow.AssertBounds();

                dropShadow.Radius.Value = 0;
                dropShadow.Invalidate();
                dropShadow.AssertBounds();

                dropShadow.Radius.Value = 8;
                dropShadow.Invalidate();
                dropShadow.AssertBounds();
            }
        }

        [WebTestMethod]
        public void Common_Unrounded()
        {
            foreach (DropShadowBehavior dropShadow in DropShadows)
            {
                dropShadow.Rounded.Value = true;
                dropShadow.Invalidate();
                dropShadow.AssertBounds();

                dropShadow.Rounded.Value = false;
                dropShadow.Invalidate();
                dropShadow.AssertBounds();
            }
        }

        [WebTestMethod]
        public void Common_Tracking()
        {
            foreach (DropShadowBehavior dropShadow in DropShadows)
            {
                dropShadow.AssertBounds();
                dropShadow.TrackPosition.Value = true;
                dropShadow.TrackPositionDelay.Value = 25;
                Common.Move(dropShadow.Element, 200, 150);
                dropShadow.WaitForBounds(3);
            }
        }

        [WebTestMethod]
        public void Common_HiddenWhenTransparent()
        {
            foreach (DropShadowBehavior dropShadow in DropShadows)
            {
                if (dropShadow.Opacity.Value == 0f)
                {
                    Assert.AreNotEqual(Display.None, dropShadow.Shadow.Reference.GetAttributes().Style.Display);
                }
            }
        }
    }
}