// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.ConfirmButton;

/// <summary>
/// SampleWebSite scenario
/// </summary>
/// <TestSuite>
///   <Path>ConfirmButton\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.ConfirmButtonBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.ConfirmButton.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("ConfirmButton.Sample")]
[WebTestTag("SampleWebSite")]
public class ConfirmButton_Sample : ConfirmButton_Common
{
    public override IEnumerable<ConfirmButtonBehavior> ConfirmButtons
    {
        get
        {
            yield return (new SamplePage()).ConfirmButtonExtender1;
            yield return (new SamplePage()).ConfirmButtonExtender2;
        }
    }
}
