// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.CollapsiblePanel;

/// <summary>
/// Simple CollapsiblePanel tests
/// </summary>
/// <TestSuite>
///   <Path>CollapsiblePanel\Simple.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.CollapsiblePanelBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.CollapsiblePanel.SimplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("CollapsiblePanel.Simple")]
public class CollapsiblePanel_Simple : CollapsiblePanel_Common
{
    public override IEnumerable<CollapsiblePanelBehavior> CollapsiblePanels
    {
        get { yield return (new SimplePage()).CollapsiblePanel; }
    }

    public override bool SupportsPostback
    {
        get { return true; }
    }

    public override void DoPostback(CollapsiblePanelBehavior collapsiblePanel)
    {
        SimplePage page = collapsiblePanel.Page as SimplePage;
        Assert.IsNotNull(page, "collapsiblePanel.Page must be of type SimplePage!");
        
        page.Button.Click(true);
        page.Invalidate();
    }
}