// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Globalization;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.Calendar;

/// <summary>
/// Basic calendar tests
/// </summary>
/// <TestSuite>
///   <Path>Calendar\Simple.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.CalendarBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.Calendar.SimplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("Calendar.Simple")]
[WebTestTag("Popup")]
public class Calendar_Simple : Calendar_Common
{
    /// <summary>
    /// Calendars on the page
    /// </summary>
    public override IEnumerable<CalendarBehavior> Calendars
    {
        get { yield return new SimplePage().Calendar; }
    }

    /// <summary>
    /// Make the common PickDate test a smoke test for the simple scenario
    /// </summary>
    [WebTestMethod]
    [WebTestTag("Smoke")]
    public override void Common_PickDate()
    {
        base.Common_PickDate();
    }
}