// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// BehaviorProperty referencing a Date
    /// </summary>
    public class DateBehaviorProperty : ReferenceBehaviorProperty<DateTime?, string>
    {
        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="behavior">Behavior that contains the property</param>
        /// <param name="name">Name of the client-side member</param>
        /// <param name="memberType">Type of the client-side member</param>
        /// <param name="readStrategy">Strategy used to synchronize the value when requested</param>
        /// <param name="writeStrategy">Strategy used to synchronize the value when set</param>
        /// <param name="lookupExpression">Custom expression used to find the object containing the property</param>
        /// <param name="getExpression">Custom expression used to get the property value from its parent object</param>
        /// <param name="setExpression">Custom expression used to set the property value on its parent object</param>
        /// <param name="propertyConverter">Optional delegate used to convert values returned by getExpression</param>
        public DateBehaviorProperty(Behavior behavior, string name, ClientMemberType memberType, ReadStrategy readStrategy, WriteStrategy writeStrategy, string lookupExpression, string getExpression, string setExpression, Converter<object, string> propertyConverter)
            : base(behavior, name, memberType, readStrategy, writeStrategy, lookupExpression, getExpression, setExpression, propertyConverter)
        {
        }

        /// <summary>
        /// Get the object corresponding to the reference
        /// </summary>
        protected override void GetReference()
        {
            DateTime result = DateTime.MinValue;
            _reference = DateTime.TryParse(base.Value, out result) ?
                (DateTime?) result :
                null;
        }
    }
}