// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// AjaxControlToolkit.GenericAnimationBehavior Model
    /// </summary>
    public class GenericAnimationBehavior : Behavior<HtmlElement>
    {
        /// <summary>
        /// GenericAnimationBehavior.get_json()
        /// </summary>
        public AnimationBehaviorProperty Animation
        {
            get { return _animation; }
        }
        private AnimationBehaviorProperty _animation;

        /// <summary>
        /// GenericAnimationBehavior.get_animation().get_isActive()
        /// </summary>
        public BehaviorProperty<bool?> IsActive
        {
            get { return _isActive; }
        }
        private BehaviorProperty<bool?> _isActive;

        /// <summary>
        /// GenericAnimationBehavior.get_animation().get_isPlaying()
        /// </summary>
        public BehaviorProperty<bool?> IsPlaying
        {
            get { return _isPlaying; }
        }
        private BehaviorProperty<bool?> _isPlaying;

        /// <summary>
        /// GenericAnimationBehavior.get_animation().get_percentComplete()
        /// </summary>
        public BehaviorProperty<float> PercentComplete
        {
            get { return _percentComplete; }
        }
        private BehaviorProperty<float> _percentComplete;

        /// <summary>
        /// GenericAnimationBehavior.get_animation().add_started(...)
        /// </summary>
        public BehaviorEvent Started
        {
            get { return _started; }
        }
        private BehaviorEvent _started;

        /// <summary>
        /// GenericAnimationBehavior.get_animation().add_ended(...)
        /// </summary>
        public BehaviorEvent Ended
        {
            get { return _ended; }
        }
        private BehaviorEvent _ended;

        /// <summary>
        /// GenericAnimationBehavior Model
        /// </summary>
        /// <param name="element">Target element</param>
        /// <param name="behaviorID">Behavior ID</param>
        /// <param name="page">Page Model</param>
        public GenericAnimationBehavior(HtmlElement element, string behaviorID, ToolkitTestPage page)
            : this(element, behaviorID, null, page)
        {
        }

        /// <summary>
        /// GenericAnimationBehavior Model
        /// </summary>
        /// <param name="element">Target element</param>
        /// <param name="behaviorID">Behavior ID</param>
        /// <param name="behaviorReferenceExpression">JavaScript expression used to reference the behavior</param>
        /// <param name="page">Page Model</param>
        public GenericAnimationBehavior(HtmlElement element, string behaviorID, string behaviorReferenceExpression, ToolkitTestPage page)
            : base(element, behaviorID, behaviorReferenceExpression, page)
        {
            _animation = new AnimationBehaviorProperty(this, "json", ClientMemberType.Property, ReadStrategy.Demand, WriteStrategy.Immediate, null, null, null, null);
            _isActive = BehaviorProperty<bool?>.CreateProperty(this, "isActive", ReadStrategy.Demand, WriteStrategy.Immediate,
                "{0}._animation", "({0} ? {0}.get_isActive() : null)", "throw 'isActive is a read-only property!'", null);
            _isPlaying = BehaviorProperty<bool?>.CreateProperty(this, "isPlaying", ReadStrategy.Demand, WriteStrategy.Immediate,
                "{0}._animation", "({0} ? {0}.get_isPlaying() : null)", "throw 'isPlaying is a read-only property!'", null);
            _percentComplete = BehaviorProperty<float>.CreateProperty(this, "percentComplete", ReadStrategy.Demand, WriteStrategy.Immediate,
                "{0}._animation", "({0} ? {0}.get_percentComplete() : 0)", "throw 'percentComplete is a read-only property!'", null);
            _started = BehaviorEvent<object>.CreateEvent(this, "started", null, "{0}._animation");
            _ended = BehaviorEvent<object>.CreateEvent(this, "ended", null, "{0}._animation");
        }

        /// <summary>
        /// Play the animation
        /// </summary>
        public void Play()
        {
            Page.ExecuteScript(string.Format("({0}).play(), true", BehaviorReferenceExpression));
        }

        /// <summary>
        /// Pause the animation
        /// </summary>
        public void Pause()
        {
            Page.ExecuteScript(string.Format("({0}).pause(), true", BehaviorReferenceExpression));
        }

        /// <summary>
        /// Stop the animation
        /// </summary>
        public void Stop()
        {
            Page.ExecuteScript(string.Format("({0}).stop(), true", BehaviorReferenceExpression));
        }

        /// <summary>
        /// Quit the animation
        /// </summary>
        public void Quit()
        {
            Page.ExecuteScript(string.Format("({0}).quit(), true", BehaviorReferenceExpression));
        }
    }
}