// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.Accordion;

/// <summary>
/// Verify an Accordion in a fixed height div does not disappear in IE
/// </summary>
/// <TestSuite>
///   <Path>Accordion\WorkItem9697.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.AccordionBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.Accordion.WorkItem9697Page</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("Accordion.WorkItem9697")]
public class Accordion_WorkItem9697 : Accordion_Common
{
    public override IEnumerable<AccordionScenario> AccordionScenarios
    {
        get { yield return new AccordionScenario(new WorkItem9697Page().Accordion, 10, null); }
    }
}