// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.Accordion;

/// <summary>
/// Ensure the Accordion works in all scenarios in IE with ClearType when FadeTransitions is false.
/// </summary>
/// <TestSuite>
///   <Path>Accordion\WorkItem10025.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.AccordionBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.Accordion.WorkItem10025Page</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("Accordion.WorkItem10025")]
public class Accordion_WorkItem10025 : Accordion_Common
{
    /// <summary>
    /// Accordion scenarios for common tests
    /// </summary>
    public override IEnumerable<AccordionScenario> AccordionScenarios
    {
        get { yield return new AccordionScenario(new WorkItem10025Page().Accordion, 4, null); }
    }
}