// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.ValidatorCallout;

/// <summary>
/// ValidatorCallout for a RequiredFieldValidator
/// </summary>
/// <TestSuite>
///   <Path>ValidatorCallout\RequiredFieldValidator.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.ValidatorCalloutBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.ValidatorCallout.RequiredFieldValidatorPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("ValidatorCallout.RequiredFieldValidator")]
public class ValidatorCallout_RequiredFieldValidator : AjaxControlToolkit.Testing.Client.ValidatorCallout.ValidatorCallout_Common
{
    public override IEnumerable<ValidatorCalloutScenario> ValidatorCalloutScenarios
    {
        get
        {
            RequiredFieldValidatorPage page = new RequiredFieldValidatorPage();
            yield return new ValidatorCalloutScenario(page.ValidatorCalloutRequired, page.TextBoxRequired, "", "text", page.Button, false, true);
        }
    }
}
