// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Drawing;
using System.Web.UI.WebControls;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.RoundedCorners;

/// <summary>
/// Typical RoundedCorners scenarios
/// </summary>
/// <TestSuite>
///   <Path>RoundedCorners\Typical.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.RoundedCornersBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.RoundedCorners.TypicalPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("RoundedCorners.Typical")]
public class RoundedCorners_Typical : AjaxControlToolkit.Testing.Client.RoundedCorners.RoundedCorners_Common
{
    public override IEnumerable<RoundedCornersBehavior> RoundedCornersBehaviors
    {
        get { yield return new TypicalPage().RoundedCornersExtender; }
    }

    [WebTestMethod]
    public void Resize()
    {
        TypicalPage page = new TypicalPage();
        Rectangle originalBounds = Common.GetBounds(page.Panel1);
        page.ExecuteScript("$get('" + page.Panel2.Id + "').innerHTML = 'Additional text';");
        Rectangle resizedBounds = Common.GetBounds(page.Panel1);
        Assert.IsTrue(originalBounds.Height < resizedBounds.Height);
    }
}
