// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.ReorderList;

/// <summary>
/// Basic ReorderList tests
/// </summary>
/// <TestSuite>
///   <Path>ReorderList\Simple.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.DropWatcherBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.ReorderList.SimplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("ReorderList.Simple")]
public class ReorderList_Simple : ReorderList_Common
{
    /// <summary>
    /// ReorderLists on the page
    /// </summary>
    public override IEnumerable<DropWatcherBehavior> ReorderLists
    {
        get { yield return new SimplePage().ReorderList; }
    }

    [WebTestMethod]
    [WebTestTag("Smoke")]
    public override void Common_Reorder()
    {
        base.Common_Reorder();
    }
}