// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;

namespace AjaxControlToolkit.Testing.Client.ReorderList
{
    /// <summary>
    /// Common ReorderList tests
    /// </summary>
    /// <TestSuite>
    ///   <ComponentType>AjaxControlToolkit.Testing.Client.DropWatcherBehavior</ComponentType>
    /// </TestSuite>
    [WebTestTag("ReorderList")]
    public abstract class ReorderList_Common
    {
        /// <summary>
        /// ReorderLists on the page
        /// </summary>
        public abstract IEnumerable<DropWatcherBehavior> ReorderLists
        {
            get;
        }

        /// <summary>
        /// Move items around
        /// </summary>
        [WebTestMethod]
        public virtual void Common_Reorder()
        {
            foreach (DropWatcherBehavior behavior in ReorderLists)
            {
                int length = behavior.GetItemsLength();
                if (length == 0)
                {
                    continue;
                }

                behavior.Reorder(0, length / 2, true);
                behavior.Reorder(0, length - 1, true);
                behavior.Reorder(length / 2, length - 1, true);
                behavior.Reorder(Math.Min(1, length - 1), length - 1, true);
                behavior.Reorder(length - 2, Math.Max(length - 2, 0), true);
            }
        }

        /// <summary>
        /// Move item to the same location (which cancels the reorder)
        /// </summary>
        [WebTestMethod]
        public void Common_Abort()
        {
            foreach (DropWatcherBehavior behavior in ReorderLists)
            {
                int length = behavior.GetItemsLength();
                if (length == 0)
                {
                    continue;
                }

                behavior.Reorder(0, 0, true);
                behavior.Reorder(length / 2, length / 2, true);
                behavior.Reorder(length - 1, length - 1, true);
            }
        }

        /// <summary>
        /// Move items from the start of the list
        /// </summary>
        [WebTestMethod]
        public void Common_ReorderStart()
        {
            foreach (DropWatcherBehavior behavior in ReorderLists)
            {
                int length = behavior.GetItemsLength();
                if (length == 0)
                {
                    continue;
                }

                behavior.Reorder(0, length / 2, true);
                behavior.Reorder(0, length - 1, true);
            }
        }

        /// <summary>
        /// Move items from the end of the list
        /// </summary>
        [WebTestMethod]
        public void Common_ReorderEnd()
        {
            foreach (DropWatcherBehavior behavior in ReorderLists)
            {
                int length = behavior.GetItemsLength();
                if (length == 0)
                {
                    continue;
                }

                behavior.Reorder(length - 1, length / 2, true);
                behavior.Reorder(length - 1, 0, true);
            }
        }
    }
}