// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// AjaxControlToolkit.NumericUpDownExtender Wrapper
    /// </summary>
    /// <TestComponent Name="NumericUpDown">
    ///   <ToolkitType>AjaxControlToolkit.NumericUpDownExtender</ToolkitType>
    ///   <CommonTestSuite>AjaxControlToolkit.Testing.Client.NumericUpDown.NumericUpDown_Common</CommonTestSuite>
    /// </TestComponent>
    public class NumericUpDownBehavior : Behavior<HtmlInputElement>
    {
        /// <summary>
        /// TargetButtonUpID
        /// </summary>
        public ReferenceBehaviorProperty<HtmlInputElement> TargetButtonUp
        {
            get { return _targetButtonUp; }
        }
        private ReferenceBehaviorProperty<HtmlInputElement> _targetButtonUp;

        /// <summary>
        /// TargetButtonDownID
        /// </summary>
        public ReferenceBehaviorProperty<HtmlInputElement> TargetButtonDown
        {
            get { return _targetButtonDown; }
        }
        private ReferenceBehaviorProperty<HtmlInputElement> _targetButtonDown;

        /// <summary>
        /// ServiceUpPath
        /// </summary>
        public BehaviorProperty<string> ServiceUpPath
        {
            get { return _serviceUpPath; }
        }
        private BehaviorProperty<string> _serviceUpPath;

        /// <summary>
        /// ServiceUpMethod
        /// </summary>
        public BehaviorProperty<string> ServiceUpMethod
        {
            get { return _serviceUpMethod; }
        }
        private BehaviorProperty<string> _serviceUpMethod;

        /// <summary>
        /// ServiceDownPath
        /// </summary>
        public BehaviorProperty<string> ServiceDownPath
        {
            get { return _serviceDownPath; }
        }
        private BehaviorProperty<string> _serviceDownPath;

        /// <summary>
        /// ServiceDownMethod
        /// </summary>
        public BehaviorProperty<string> ServiceDownMethod
        {
            get { return _serviceDownMethod; }
        }
        private BehaviorProperty<string> _serviceDownMethod;

        /// <summary>
        /// Step
        /// </summary>
        public BehaviorProperty<double> Step
        {
            get { return _step; }
        }
        private BehaviorProperty<double> _step;

        /// <summary>
        /// Minimum
        /// </summary>
        public BehaviorProperty<double> Minimum
        {
            get { return _minimum; }
        }
        private BehaviorProperty<double> _minimum;

        /// <summary>
        /// Maximum
        /// </summary>
        public BehaviorProperty<double> Maximum
        {
            get { return _maximum; }
        }
        private BehaviorProperty<double> _maximum;

        /// <summary>
        /// RefValues
        /// </summary>
        public BehaviorProperty<string> RefValues
        {
            get { return _refValues; }
        }
        private BehaviorProperty<string> _refValues;

        /// <summary>
        /// Width
        /// </summary>
        public BehaviorProperty<int> Width
        {
            get { return _width; }
        }
        private BehaviorProperty<int> _width;

        /// <summary>
        /// Tag
        /// </summary>
        public BehaviorProperty<string> Tag
        {
            get { return _tag; }
        }
        private BehaviorProperty<string> _tag;

        /// <summary>
        /// CurrentChanged
        /// </summary>
        public BehaviorEvent CurrentChanged
        {
            get { return _currentChanged; }
        }
        private BehaviorEvent _currentChanged;


        /// <summary>
        /// AjaxControlToolkit.NumericUpDownExtender Wrapper
        /// </summary>
        /// <param name="element">Target element</param>
        /// <param name="behaviorID">Behavior ID</param>
        /// <param name="page">Page Wrapper</param>
        public NumericUpDownBehavior(HtmlInputElement element, string behaviorID, ToolkitTestPage page)
            : base(element, behaviorID, page)
        {
            _targetButtonUp = ReferenceBehaviorProperty<HtmlInputElement>.CreateField(this, "id", "{0}._bUp");
            _targetButtonDown = ReferenceBehaviorProperty<HtmlInputElement>.CreateField(this, "id", "{0}._bDown");
            _serviceUpPath = BehaviorProperty<string>.CreateProperty(this, "ServiceUpPath");
            _serviceUpMethod = BehaviorProperty<string>.CreateProperty(this, "ServiceUpMethod");
            _serviceDownPath = BehaviorProperty<string>.CreateProperty(this, "ServiceDownPath");
            _serviceDownMethod = BehaviorProperty<string>.CreateProperty(this, "ServiceDownMethod");
            _step = BehaviorProperty<double>.CreateProperty(this, "Step");
            _minimum = BehaviorProperty<double>.CreateProperty(this, "Minimum");
            _maximum = BehaviorProperty<double>.CreateProperty(this, "Maximum");
            _refValues = BehaviorProperty<string>.CreateProperty(this, "RefValues");
            _width = BehaviorProperty<int>.CreateProperty(this, "Width");
            _tag = BehaviorProperty<string>.CreateProperty(this, "Tag");
            _currentChanged = BehaviorEvent<object>.CreateEvent(this, "currentChanged");
        }

        /// <summary>
        /// Click the up button
        /// </summary>
        public void ClickUp()
        {
            this.CurrentChanged.Register();
            this.TargetButtonUp.Reference.Click();
            this.CurrentChanged.Wait(2);
        }

        /// <summary>
        /// Click the down button
        /// </summary>
        public void ClickDown()
        {
            this.CurrentChanged.Register();
            this.TargetButtonDown.Reference.Click();
            this.CurrentChanged.Wait(2);
        }
    }
}