// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.ModalPopup;

/// <summary>
/// SampleWebSite scenario
/// </summary>
/// <TestSuite>
///   <Path>ModalPopup\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.ModalPopupBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.ModalPopup.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("ModalPopup.Sample")]
[WebTestTag("SampleWebSite")]
public class ModalPopup_Sample : AjaxControlToolkit.Testing.Client.ModalPopup.ModalPopup_Common
{
    public override IEnumerable<ModalPopupBehavior> ModalPopups
    {
        get 
        { 
            SamplePage page = new SamplePage();
            yield return page.ModalPopupExtender;
            yield return page.programmaticModalPopup;
        }
    }
}