// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// AjaxControlToolkit.HoverMenuExtender Model
    /// </summary>
    /// <TestComponent Name="HoverMenu">
    ///   <ToolkitType>AjaxControlToolkit.HoverMenuExtender</ToolkitType>
    ///   <CommonTestSuite>AjaxControlToolkit.Testing.Client.HoverMenu.HoverMenu_Common</CommonTestSuite>
    /// </TestComponent>
    public class HoverMenuBehavior : Behavior<HtmlElement>
    {
        /// <summary>
        /// PopupControl
        /// </summary>
        public ReferenceBehaviorProperty<HtmlElement> PopupControl
        {
            get { return _popupControl; }
        }
        private ReferenceBehaviorProperty<HtmlElement> _popupControl;

        /// <summary>
        /// HoverCssClass
        /// </summary>
        public BehaviorProperty<string> HoverCssClass
        {
            get { return _hoverCssClass; }
        }
        private BehaviorProperty<string> _hoverCssClass;

        /// <summary>
        /// OffsetX
        /// </summary>
        public BehaviorProperty<int> OffsetX
        {
            get { return _offsetX; }
        }
        private BehaviorProperty<int> _offsetX;

        /// <summary>
        /// OffsetY
        /// </summary>
        public BehaviorProperty<int> OffsetY
        {
            get { return _offsetY; }
        }
        private BehaviorProperty<int> _offsetY;

        /// <summary>
        /// PopDelay
        /// </summary>
        public BehaviorProperty<int> PopDelay
        {
            get { return _popDelay; }
        }
        private BehaviorProperty<int> _popDelay;

        /// <summary>
        /// PopupPosition
        /// </summary>
        public BehaviorProperty<HoverMenuPopupPosition> PopupPosition
        {
            get { return _popupPosition; }
        }
        private BehaviorProperty<HoverMenuPopupPosition> _popupPosition;

        /// <summary>
        /// DynamicControl
        /// </summary>
        public ReferenceBehaviorProperty<HtmlElement> DynamicControl
        {
            get { return _dynamicControl; }
        }
        private ReferenceBehaviorProperty<HtmlElement> _dynamicControl;

        /// <summary>
        /// DynamicContextKey
        /// </summary>
        public BehaviorProperty<string> DynamicContextKey
        {
            get { return _dynamicContextKey; }
        }
        private BehaviorProperty<string> _dynamicContextKey;

        /// <summary>
        /// DynamicServicePath
        /// </summary>
        public BehaviorProperty<string> DynamicServicePath
        {
            get { return _dynamicServicePath; }
        }
        private BehaviorProperty<string> _dynamicServicePath;

        /// <summary>
        /// DynamicServiceMethod
        /// </summary>
        public BehaviorProperty<string> DynamicServiceMethod
        {
            get { return _dynamicServiceMethod; }
        }
        private BehaviorProperty<string> _dynamicServiceMethod;

        /// <summary>
        /// CacheDynamicResults
        /// </summary>
        public BehaviorProperty<bool> CacheDynamicResults
        {
            get { return _cacheDynamicResults; }
        }
        private BehaviorProperty<bool> _cacheDynamicResults;
        
        /// <summary>
        /// HoverBehavior
        /// </summary>
        public HoverBehavior HoverBehavior
        {
            get { return _hoverBehavior; }
        }
        private HoverBehavior _hoverBehavior;

        /// <summary>
        /// PopupBehavior
        /// </summary>
        public PopupBehavior PopupBehavior
        {
            get
            {
                if (_popupBehavior == null)
                {
                    _popupBehavior = new PopupBehavior(
                        _popupControl.Reference,
                        BehaviorID + "_PopupBehavior",
                        string.Format("{0}._PopupBehavior", BehaviorReferenceExpression),
                        Page);
                }
                return _popupBehavior;
            }
        }
        private PopupBehavior _popupBehavior;
        
        /// <summary>
        /// AjaxControlToolkit.HoverMenuExtender Model
        /// </summary>
        /// <param name="element">Target element</param>
        /// <param name="behaviorID">Behavior ID</param>
        /// <param name="page">Page Model</param>
        public HoverMenuBehavior(HtmlElement element, string behaviorID, ToolkitTestPage page)
            : base(element, behaviorID, page)
        {
            _popupControl = ReferenceBehaviorProperty<HtmlElement>.CreateField(this, "id", "{0}._popupElement");
            _hoverCssClass = BehaviorProperty<string>.CreateProperty(this, "HoverCssClass");
            _offsetX = BehaviorProperty<int>.CreateProperty(this, "OffsetX");
            _offsetY = BehaviorProperty<int>.CreateProperty(this, "OffsetY");
            _popDelay = BehaviorProperty<int>.CreateProperty(this, "PopDelay");
            _popupPosition = BehaviorProperty<HoverMenuPopupPosition>.CreateProperty(this, "PopupPosition");
            _dynamicControl = ReferenceBehaviorProperty<HtmlElement>.CreateProperty(this, "dynamicControlID");
            _dynamicContextKey = BehaviorProperty<string>.CreateProperty(this, "dynamicContextKey");
            _dynamicServicePath = BehaviorProperty<string>.CreateProperty(this, "dynamicServicePath");
            _dynamicServiceMethod = BehaviorProperty<string>.CreateProperty(this, "dynamicServiceMethod");
            _cacheDynamicResults = BehaviorProperty<bool>.CreateProperty(this, "cacheDynamicResults");
            _hoverBehavior = new HoverBehavior(
                    element, 
                    behaviorID + "_hoverBehavior", 
                    string.Format("{0}._hoverBehavior", BehaviorReferenceExpression), 
                    page);
        }

        /// <summary>
        /// Hover/Unhover
        /// </summary>
        public void AssertHoverUnHover()
        {
            this.AssertHover();
            this.AssertUnHover();
        }

        /// <summary>
        /// Hover and confirm that the menu shows
        /// </summary>
        public void AssertHover()
        {
            this.HoverBehavior.HoverOver();
            Assert.IsFalse(this.IsMenuHidden);
        }

        /// <summary>
        /// Hover and confirm that the menu is hidden
        /// </summary>
        public void AssertUnHover()
        {
            this.HoverBehavior.HoverOut();
            Assert.IsTrue(this.IsMenuHidden);
        }

        /// <summary>
        /// Returns Menu hidden state
        /// </summary>
        public bool IsMenuHidden
        {
            get
            {
                HtmlStyle popupStyle = this.PopupControl.Reference.GetAttributes().Style;
                return ((popupStyle.Display == Display.None) || (popupStyle.Visibility == Visibility.Hidden));
            }
        }

    }
}