// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;

namespace AjaxControlToolkit.Testing.Client.HoverMenu
{
    /// <summary>
    /// Common HoverMenu tests
    /// </summary>
    /// <TestSuite>
    ///   <ComponentType>AjaxControlToolkit.Testing.Client.HoverMenuBehavior</ComponentType>
    /// </TestSuite>
    [WebTestTag("HoverMenu")]
    [WebTestTag("Hover")]
    public abstract class HoverMenu_Common
    {
        public abstract IEnumerable<HoverMenuBehavior> HoverMenus
        {
            get;
        }

        [WebTestMethod]
        public void Common_HoverUnHover()
        {
            foreach (HoverMenuBehavior hoverMenu in this.HoverMenus)
            {
                hoverMenu.AssertHoverUnHover();
            }
        }
    }
}