// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.FilteredTextBox;

/// <summary>
/// Make sure that if invalid chars are passed then they get filtered correctly
/// </summary>
/// <TestSuite>
///   <Path>FilteredTextBox\FilterModeInvalidChars.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.FilteredTextBoxBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.FilteredTextBox.FilterModeInvalidCharsPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("FilteredTextBox.FilterModeInvalidChars")]
public class FilteredTextBox_FilterModeInvalidChars : AjaxControlToolkit.Testing.Client.FilteredTextBox.FilteredTextBox_Common
{
    public override IEnumerable<FilteredTextBoxBehavior> FilteredTextBoxes
    {
        get 
        {
            yield return new FilterModeInvalidCharsPage().FilteredTextBoxExtender6;
        }
    }
}