// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.DynamicPopulate;

/// <summary>
/// Simple DynamicPopulate page method test
/// </summary>
/// <TestSuite>
///   <Path>DynamicPopulate\PageMethod.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.DynamicPopulateBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.DynamicPopulate.PageMethodPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("DynamicPopulate.PageMethod")]
public class DynamicPopulate_PageMethod : AjaxControlToolkit.Testing.Client.DynamicPopulate.DynamicPopulate_Common
{
    public const int WaitDuration = 250;

    public override IEnumerable<Tuple<DynamicPopulateBehavior, string>> DynamicPopulation
    {
        get { yield return new Tuple<DynamicPopulateBehavior, string>(new PageMethodPage().DynamicPopulate, DynamicContent); }
    }
}