// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.ConfirmButton;

/// <summary>
/// Basic ConfirmButtonExtender tests
/// </summary>
/// <TestSuite>
///   <Path>ConfirmButton\Simple.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.ConfirmButtonBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.ConfirmButton.SimplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("ConfirmButton.Simple")]
public class ConfirmButton_Simple : ConfirmButton_Common
{
    public override IEnumerable<ConfirmButtonBehavior> ConfirmButtons
    {
        get
        {
            SimplePage sp = new SimplePage();
            yield return sp.cbeButtonExtender;
            yield return sp.cbeSubmitButtonExtender;            
        }
    }

    [WebTestMethod]    
    public void SubmitBehavior_Confirm()
    {
        SimplePage cp = new SimplePage();
        cp.cbeSubmitButtonExtender.ForceConfirmation();
        cp.cbeSubmitButtonExtender.Element.Click(true);
    }

    [WebTestMethod]
    [WebTestTag("Smoke")]
    public void SubmitBehavior_Ignore()
    {
        SimplePage cp = new SimplePage();
        cp.cbeSubmitButtonExtender.AssertIgnored();
        
    }
}